#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef unsigned char u8;
typedef unsigned long u32;

u8            scr_tbl[64] = {
  0x3d, 0xd6, 0xf4, 6, 0xa3, 0xc9, 0x8d, 0xcd, 0x3a, 0xe6, 0x4e, 0x52,
  0xd9, 0xff, 2, 0x61, 0xb9, 0x42, 0x7a, 0x20, 0x37, 0xc8, 0xb4, 0x1e, 0xe,
  0x8f, 3, 0xc, 0xba, 0x67, 0x62, 0x40, 0x45, 0x38, 0xfc, 0x4c, 0x1a, 0xbc,
  0x6d, 0xc7, 0xdb, 0x12, 0x87, 0xdb, 0x21, 0x90, 0xf6, 0x97, 0xdf, 0x90,
  0xd2, 0x4f, 0xf5, 0x9f, 0xfd, 1, 0xd0, 0x54, 0x13, 0x13, 0xe2, 0xc7,
  0xc5, 0x28 
};

u32
auth_code( u32 a1 )
{
  u32           v2, v4;
  u8           *v3;

  v2 = a1;
  v3 = scr_tbl;
  do
  {
    v2 ^= *( u32 * ) &scr_tbl[4 * ( ( a1 >> ( ( u8 ) v3 - ( u32 ) scr_tbl ) ) & 0xf )];
    v4 = *( u32 * ) v3;
    v3 += 4;
    a1 ^= v4;
  }
  while( v3 != &scr_tbl[32] );
  return v2;
}

int
main( int argc, char *argv[] )
{
  u32 challenge;

  printf( "Zaquencer V1.5 Authorization Generator\n" );
  printf( "Usage: %s [challenge]\n\n", argv[0] );
  if( argc > 1 )
    challenge = strtoul( argv[1], NULL, 16 );
  else
  {
    srand( time( NULL ) );
    challenge = rand( );
  }
  printf( "%s %08lX -> %s %08lX\n", 
      (argc > 1) ? "Challenge" : "DemoChal", challenge, 
      (argc > 1) ? "Authorization" : "DemoAuth", auth_code( challenge ) );
  return 0;
}
